remove_outlier <- function(dataFrame = dat, token_index, pos_index, pitch, pitch_diff = 80, cluster_size = 3){
  res = list()
  tokens = as.character(unique(dataFrame[[token_index]]))
  #print(length(tokens))
  for (ii in 1:length(tokens)){
      tmp = dataFrame[dataFrame[[token_index]]==tokens[[ii]],]
      tmp = tmp[!is.na(tmp[[pitch]]),]
      if(nrow(tmp)==0){
        res[[ii]] = NA
      } else {
          alldiffs = diff(tmp[[pitch]], lag=1)
          clind = c(which(abs(alldiffs) > pitch_diff), length(tmp[[pitch]]))
          clinds = rep(0, length(tmp[[pitch]]))
          cnt = 1
          for (jj in 1:length(clinds)){
            if(jj<=clind[cnt]){
              clinds[jj] = cnt
            } else {
              cnt = cnt+1
              clinds[jj] = cnt
            }
          }
          clex = which(sapply(unique(clinds), FUN=function(v) length(clinds[clinds==v]))<=cluster_size)
          if (length(clex)>0){
            res[[ii]] = tmp[[pos_index]][which(clinds%in%clex)]
          } else{
            res[[ii]] = NA
          }
      }
      if(ii%%500==0) print(ii)
  }
  res = unlist(res)
  return(res[!is.na(res)])
}


remove_outlier_sd <- function(dataFrame, factor, response, scale_sd = 2){
    res = list()
    dat_ls = split(dataFrame, as.factor(dataFrame[[factor]]))
    for (i in 1:length(dat_ls)){
        tmp = dat_ls[[i]]
        sds = sd(tmp[[response]])
        means = mean(tmp[[response]])
        tmp = droplevels(tmp[tmp[[response]] > means-(scale_sd*sds) & tmp[[response]] < means+(scale_sd*sds),])
        res[[i]] = tmp
    }
    return(do.call(rbind, res))
}



plop <- function(x, y){
  options(repr.plot.width=x, repr.plot.height=y)
}


plot_by_device <- function(df, item.var, item, speaker.var, speaker, res, yr, xpred="measurement.no"){
  tdf = df[df[[item.var]]==item & df[[speaker.var]]==speaker,]
  tdf = tdf[!is.na(tdf[[res]]),]
  devs = c("H6", "AVR", "Zoom-default", "Zoom-raw")
  par(mfrow=c(1,4))
  for (i in 1:4){
    tdfa = tdf[tdf$device==devs[i],]
    plot(tdfa[[xpred]], tdfa[[res]], main=devs[i], pch=19, xlim=c(0,1),ylim=yr,
         xlab=xpred, ylab=res)
  }
}

plot_token_contour <- function(data, response, listSep,
                 fileName, fileWidth=6, fileHeight=10, 
                             numSp=8, colors=c(1:4),
                             yrange=NULL, xrange=c(0,1),
                             pointSize=0.5){

  data_list = split(data, as.factor(data[[listSep]]))

  cols = rep(colors, numSp)
  contour_color <- function(x, y) {
        panel.xyplot(x, y, pch=19, cex=pointSize, col=cols[panel.number()])
      }
  fmla = formula(paste0(response, "~ measurement.no|device + speaker"))

  pdf(fileName, wi=fileWidth, he=fileHeight)
  for (i in 1:length(data_list)){
    if(!is.null(yrange)){
      yr = yrange
    } else {
      yr = c(floor(min(data_list[[i]][,response])), ceiling(max(data_list[[i]][,response])))
    }
    print(xyplot(fmla, 
               data=data_list[[i]], panel=contour_color,
               par.strip.text=list(cex=0.7),
               ylab=paste(response, data_list[[i]][,listSep][1], sep="_"),
               xlim=xrange, ylim=yr)
          )
  }
  dev.off()
}


plot_ave_curves <- function(df, variable, categories=NULL,
                            response,y_axis_label, x_axis_label, timeVar="measurement.no",
                            yrange, xlabel="time", xrange=c(0,1),
                            pos="bottomright", smoothness=2,
                            legend.out=FALSE, print.legend=TRUE,
                            cols=NULL, lineTypes=NULL){
  if(is.null(categories)){
    categories = unique(as.character(df[[variable]]))
  }
  if(is.null(cols)){
    cols = c(1:length(categories))
  }
  if(is.null(lineTypes)){
    lineTypes = rep(1, length(categories))
  }

  for (i in 1:length(categories)){
    tdf = df[df[[variable]]==categories[i],]
    tdf$time = round(tdf[[timeVar]], smoothness)
    ms = tapply(tdf[[response]], tdf$time, mean)
    if(i==1){
      par(mar=c(5,5,2,2))
      plot(as.numeric(names(ms)), ms, type="l", xlim=xrange, ylim=yrange, 
           xlab=x_axis_label, ylab=y_axis_label, lwd=2, lty=lineTypes[i], col=cols[i],cex.lab=1.5, cex.main=1.5, cex.sub=1.5, cex.axis= 1.2)
    } else {
      lines(as.numeric(names(ms)), ms, col=cols[i], ylim=yrange, lwd=2, lty=lineTypes[i])
    }  
  }

  if (print.legend){
    if (legend.out){
      legend(pos, categories, inset=c(-0.4,0), lwd=2, col=cols, bty="n", lty=lineTypes)
    }else{
      legend(pos, categories, lwd=2, col=cols, bty="n", lty=lineTypes)
    }
  }
}


plot_model_diff <- function(m, yrange, y_axis_label="", x_axis_label="", title1="", title2="", title3="", title4="", intercepts=NULL, sels=c(1:4)){
  if (!is.null(intercepts)){
    incps = summary(m)$p.coeff[intercepts]
    sigsP = round(summary(m)$p.pv[intercepts],4)
    sigsS = round(summary(m)$s.pv[sels[2:4]],4)

    par(mfrow=c(1,4))
    par(mar=c(5,5,2,2))
    
    plot(m, select=sels[1], ylab=y_axis_label, xlab=x_axis_label,cex.lab=1.5, cex.main=1.5, cex.sub=1.5); abline(h=0);axis(side = 1, at=c(seq(from=0,to=1,by=0.1), cex.axis=2))
    plot(m, select=sels[2], ylim=yrange, ylab=y_axis_label, xlab=x_axis_label,cex.lab=1.5, cex.main=1.5, cex.sub=1.5, shift=incps[1]); abline(h=0); mtext(paste(sigsP[1], sigsS[1], sep=" , "), side=3, line=-2);axis(side = 1, at=c(seq(from=0,to=1,by=0.1), cex.axis=2))
    plot(m, select=sels[3], ylim=yrange, ylab=y_axis_label, xlab=x_axis_label,cex.lab=1.5, cex.main=1.5, cex.sub=1.5, shift=incps[2]); abline(h=0); mtext(paste(sigsP[2], sigsS[2], sep=" , "), side=3, line=-2);axis(side = 1, at=c(seq(from=0,to=1,by=0.1), cex.axis=2))
    plot(m, select=sels[4], ylim=yrange, ylab=y_axis_label, xlab=x_axis_label,cex.lab=1.5, cex.main=1.5, cex.sub=1.5, shift=incps[3]); abline(h=0); mtext(paste(sigsP[3], sigsS[3], sep=" , "), side=3, line=-2);axis(side = 1, at=c(seq(from=0,to=1,by=0.1), cex.axis=2))

  } else {
    sigsS = round(summary(m)$s.pv[sels[2:4]],5)
    sigsSlab = sapply(sigsS, function(v) ifelse(v<0.0001, "p < 0.0001", ""))
    par(mfrow=c(1,4))
    par(mar=c(5,5,2,2))
    plot(m, select=sels[1], ylab=y_axis_label, xlab=x_axis_label,cex.lab=1.5, main=title1, cex.main=1.5, cex.sub=1.5);abline(h=0);axis(side = 1, at=c(seq(from=0,to=1,by=0.1), cex.axis=2))

    plot(m, select=sels[2], ylim=yrange, ylab=y_axis_label, xlab=x_axis_label,main=title2, cex.lab=1.5, cex.main=1.5, cex.sub=1.5); abline(h=0); mtext(sigsSlab[1], side=3, line=-2);axis(side = 1, at=c(seq(from=0,to=1,by=0.1), cex.axis=2))
    plot(m, select=sels[3], ylim=yrange, ylab=y_axis_label, xlab=x_axis_label,main=title3, cex.lab=1.5, cex.main=1.5, cex.sub=1.5); abline(h=0); mtext(sigsSlab[2], side=3, line=-2);axis(side = 1, at=c(seq(from=0,to=1,by=0.1), cex.axis=2))
    plot(m, select=sels[4], ylim=yrange, ylab=y_axis_label, xlab=x_axis_label,main=title4, cex.lab=1.5, cex.main=1.5, cex.sub=1.5); abline(h=0); mtext(sigsSlab[3], side=3, line=-2);axis(side = 1, at=c(seq(from=0,to=1,by=0.1), cex.axis=2))
  }
}

plot_model_diff3 <- function(m, yrange, y_axis_label="", x_axis_label="", title1="", title2="", title3="", intercepts=NULL, sels=c(1:4)){
  if (!is.null(intercepts)){
    incps = summary(m)$p.coeff[intercepts]
    sigsP = round(summary(m)$p.pv[intercepts],4)
    sigsS = round(summary(m)$s.pv[sels[2:4]],4)
    
    par(mfrow=c(1,3))
    par(mar=c(5,5,2,2))
    
    plot(m, select=sels[2], ylim=yrange, ylab=y_axis_label, xlab=x_axis_label,main=title1, cex.lab=1.5, cex.main=1.5, cex.sub=1.5, shift=incps[1]); abline(h=0); mtext(paste(sigsP[1], sigsS[1], sep=" , "), side=3, line=-2);axis(side = 1, at=c(seq(from=0,to=1,by=0.1), cex.axis=2))
    plot(m, select=sels[3], ylim=yrange, ylab=y_axis_label, xlab=x_axis_label,main=title2, cex.lab=1.5, cex.main=1.5, cex.sub=1.5, shift=incps[2]); abline(h=0); mtext(paste(sigsP[2], sigsS[2], sep=" , "), side=3, line=-2);axis(side = 1, at=c(seq(from=0,to=1,by=0.1), cex.axis=2))
    plot(m, select=sels[4], ylim=yrange, ylab=y_axis_label, xlab=x_axis_label,main=title3, cex.lab=1.5, cex.main=1.5, cex.sub=1.5, shift=incps[3]); abline(h=0); mtext(paste(sigsP[3], sigsS[3], sep=" , "), side=3, line=-2);axis(side = 1, at=c(seq(from=0,to=1,by=0.1), cex.axis=2))
    
  } else {
    sigsS = round(summary(m)$s.pv[sels[2:4]],5)
    sigsSlab = sapply(sigsS, function(v) ifelse(v<0.0001, "p < 0.0001", ""))
    par(mfrow=c(1,3))
    par(mar=c(5,5,2,2))

    plot(m, select=sels[2], ylim=yrange, ylab=y_axis_label, xlab=x_axis_label,main=title1, cex.lab=1.5, cex.main=1.5, cex.sub=1.5); abline(h=0); mtext(sigsSlab[1], side=3, line=-2);axis(side = 1, at=c(seq(from=0,to=1,by=0.1), cex.axis=2))
    plot(m, select=sels[3], ylim=yrange, ylab=y_axis_label, xlab=x_axis_label,main=title2, cex.lab=1.5, cex.main=1.5, cex.sub=1.5); abline(h=0); mtext(sigsSlab[2], side=3, line=-2);axis(side = 1, at=c(seq(from=0,to=1,by=0.1), cex.axis=2))
    plot(m, select=sels[4], ylim=yrange, ylab=y_axis_label, xlab=x_axis_label,main=title3, cex.lab=1.5, cex.main=1.5, cex.sub=1.5); abline(h=0); mtext(sigsSlab[3], side=3, line=-2);axis(side = 1, at=c(seq(from=0,to=1,by=0.1), cex.axis=2))
  }
}

get_diff <- function(x, y){
  if(is.na(x) & is.na(y)){
    return(NA)
  } else if (is.na(x) & !is.na(y)) {
    return(NA)
  } else if (!is.na(x) & is.na(y)) {
    return(NA)
  } else {
    return(y-x)
  }
}

remove_nas <- function(df, v, n=NULL, sel=FALSE, v_sel=NULL, v_value=NULL){
  tdf = df[!is.na(df[[v]]),]
  if(!is.null(n)){
     tdf = tdf[abs(tdf[[v]])<=n,]
  }
  if(sel){
    tdf = tdf[tdf[[v_sel]]==v_value,]
  }
  return(tdf)
}




success_or_failure <- function(x, y, eps){
  if(is.na(x) & is.na(y)){
    return(TRUE)
  } else if (is.na(x) & !is.na(y)) {
    return(FALSE)
  } else if (!is.na(x) & is.na(y)) {
    return(FALSE)
  } else {
    if (y < (x+eps) & y > (x-eps)) {
      return(TRUE)
    } else {
      return(FALSE)
    }
  }
}


further_classify <- function(x, y, eps_cor, eps_w1, eps_w2){
  if(is.na(x) & is.na(y)){
    return("correctAbsent")
  } else if (is.na(x) & !is.na(y)) {
    return("falseAlarm")
  } else if (!is.na(x) & is.na(y)) {
    return("miss")
  } else {
    di = y - x
    if (abs(di) < eps_cor) {
      return("match")
    } else if (di > eps_cor & di < eps_w1){
      return("up1")
    } else if (di < (-1*eps_cor) & di > (-1*eps_w1)) {
      return("down1")
    } else if (di > eps_w1 & di < eps_w2){
      return("up2")
    } else if (di < (-1*eps_w1) & di > (-1*eps_w2)) {
      return("down2")
    } else {
      return("error")
    }
  }
}



get_total_success <- function(res_ls, preds){
  sus = vector()
  for (i in 1:length(preds)){
    tsus = unname(sapply(res_ls, function(ls) table(ls[[preds[i]]])["TRUE"]))
    sus = c(sus, tsus)
  }
  sus[is.na(sus)] = 0
  return(sus)
}

get_total_failure <- function(res_ls, preds){
  fas = vector()
  for (i in 1:length(preds)){
    tfas = unname(sapply(res_ls, function(ls) table(ls[[preds[i]]])["FALSE"]))
    fas = c(fas, tfas)
  }
  fas[is.na(fas)] = 0
  return(fas)
}


code_order <- function(df, device, type){
  label = paste(paste0("Is",device), type, sep=".")
  label = gsub("-", ".", label)
  df[[label]] = 0
  df[[label]][df$device==device & df$formantVow==type] = 1
  df[[label]] = as.ordered(df[[label]])
  contrasts(df[[label]]) <- "contr.treatment"
  return(df)
}


plot_2D_formants <- function(m, xrange = c(-2600, -1200), yrange = c(-1000,-400),
                             devices = c("H6", "AVR", "Zoom-default", "Zoom-raw"),
                             plot_time = TRUE,
                             ts = seq(0,1,length=100), ncol_by = 0.01,
                             col_starts = c("black", "red", "darkgreen", "darkblue"),
                             col_ends = c("grey80", "lightpink", "lightgreen", "lightblue"),
                             vspace=FALSE, tri_sels = c(10, 50, 90), j = 2){

    # H6
    i=1
    cl = colorRamp(c(col_starts[i], col_ends[i]))
    cols = rgb(cl(ts),maxColorValue=256)

    ms_x_a = get_predictions(m, cond=list(deviceFormantVow=paste(devices[i], "f2.a", sep="."), measurement.no=ts), print.summary=F)$fit
    ms_y_a = get_predictions(m, cond=list(deviceFormantVow=paste(devices[i], "f1.a", sep="."), measurement.no=ts), print.summary=F)$fit
    ms_x_i = get_predictions(m, cond=list(deviceFormantVow=paste(devices[i], "f2.i", sep="."), measurement.no=ts), print.summary=F)$fit
    ms_y_i = get_predictions(m, cond=list(deviceFormantVow=paste(devices[i], "f1.i", sep="."), measurement.no=ts), print.summary=F)$fit
    ms_x_u = get_predictions(m, cond=list(deviceFormantVow=paste(devices[i], "f2.u", sep="."), measurement.no=ts), print.summary=F)$fit
    ms_y_u = get_predictions(m, cond=list(deviceFormantVow=paste(devices[i], "f1.u", sep="."), measurement.no=ts), print.summary=F)$fit

    if (plot_time){
      plot(-ms_x_a, -ms_y_a, pch=19, col=cols, xlim=xrange, ylim=yrange, xlab="f2", ylab="f1", xaxt="n", yaxt="n")
      axis(side=1, at=seq(xrange[1], xrange[2], by=200), label=seq(-1*xrange[1], -1*xrange[2], by=-200))
      axis(side=2, at=seq(yrange[1], yrange[2], by=100), label=seq(-1*yrange[1], -1*yrange[2], by=-100))
      points(-ms_x_i, -ms_y_i, pch=19, col=cols, xlim=xrange, ylim=yrange)
      points(-ms_x_u, -ms_y_u, pch=19, col=cols, xlim=xrange, ylim=yrange)
    } else {
      plot(-ms_x_a, -ms_y_a, pch=19, col="white", xlim=xrange, ylim=yrange, xlab="f2", ylab="f1", xaxt="n", yaxt="n")
      axis(side=1, at=seq(xrange[1], xrange[2], by=200), label=seq(-1*xrange[1], -1*xrange[2], by=-200))
      axis(side=2, at=seq(yrange[1], yrange[2], by=100), label=seq(-1*yrange[1], -1*yrange[2], by=-100))
    }

    if (vspace){
        xs = c(ms_x_a[tri_sels[j]], ms_x_i[tri_sels[j]], ms_x_u[tri_sels[j]], ms_x_a[tri_sels[j]])
        ys = c(ms_y_a[tri_sels[j]], ms_y_i[tri_sels[j]], ms_y_u[tri_sels[j]], ms_y_a[tri_sels[j]])
        lines(-xs, -ys, col=cols[tri_sels[j]], xlim=xrange, ylim=yrange, lwd=2)
    }

    for (i in 2:4){
        cl = colorRamp(c(col_starts[i], col_ends[i]))
        cols = rgb(cl(ts),maxColorValue=256)

        ms_x_a = get_predictions(m, cond=list(deviceFormantVow=paste(devices[i], "f2.a", sep="."), measurement.no=ts), print.summary=F)$fit
        ms_y_a = get_predictions(m, cond=list(deviceFormantVow=paste(devices[i], "f1.a", sep="."), measurement.no=ts), print.summary=F)$fit
        ms_x_i = get_predictions(m, cond=list(deviceFormantVow=paste(devices[i], "f2.i", sep="."), measurement.no=ts), print.summary=F)$fit
        ms_y_i = get_predictions(m, cond=list(deviceFormantVow=paste(devices[i], "f1.i", sep="."), measurement.no=ts), print.summary=F)$fit
        ms_x_u = get_predictions(m, cond=list(deviceFormantVow=paste(devices[i], "f2.u", sep="."), measurement.no=ts), print.summary=F)$fit
        ms_y_u = get_predictions(m, cond=list(deviceFormantVow=paste(devices[i], "f1.u", sep="."), measurement.no=ts), print.summary=F)$fit

        if (plot_time){
          points(-ms_x_a, -ms_y_a, pch=19, col=cols, xlim=xrange, ylim=yrange)
          points(-ms_x_i, -ms_y_i, pch=19, col=cols, xlim=xrange, ylim=yrange)
          points(-ms_x_u, -ms_y_u, pch=19, col=cols, xlim=xrange, ylim=yrange)
        }

        if (vspace){
            xs = c(ms_x_a[tri_sels[j]], ms_x_i[tri_sels[j]], ms_x_u[tri_sels[j]], ms_x_a[tri_sels[j]])
            ys = c(ms_y_a[tri_sels[j]], ms_y_i[tri_sels[j]], ms_y_u[tri_sels[j]], ms_y_a[tri_sels[j]])
            lines(-xs, -ys, col=cols[tri_sels[j]], xlim=xrange, ylim=yrange, lwd=2)
        }
    }

    legend("bottomleft", devices, lwd=2, col=col_starts, bty="n")
}


plot_2D_formants_raw <- function(dat, devices = c("H6", "AVR", "Zoom-default", "Zoom-raw"),
                                 xrange = c(-2600, -1200),
                                 yrange = c(-900,-300),
                                 ts = c(0.1, 0.5, 0.9)){

  dat$device = relevel(as.factor(dat$device), "H6")
#  datcv$deviceOrd = as.ordered(datcv$device)
  vs = split(dat, dat$device)
  res = list()
  for (i in 1:length(vs)){
    tdf = vs[[i]]
    tdf$newtime = round(tdf$measurement.no, 3)
    xs_a = vector()
    ys_a = vector()
    xs_i = vector()
    ys_i = vector()
    xs_u = vector()
    ys_u = vector()
    for (j in 1:length(ts)){
      tsU = ts[j] + 0.02
      tsL = ts[j] - 0.02
      xs_a = c(xs_a, mean(tdf[tdf$newtime<=tsU & tdf$newtime>=tsL & tdf$formantVow=="f2.a", "formantValue"]))
      ys_a = c(ys_a, mean(tdf[tdf$newtime<=tsU & tdf$newtime>=tsL & tdf$formantVow=="f1.a", "formantValue"]))
      xs_i = c(xs_i, mean(tdf[tdf$newtime<=tsU & tdf$newtime>=tsL & tdf$formantVow=="f2.i", "formantValue"]))
      ys_i = c(ys_i, mean(tdf[tdf$newtime<=tsU & tdf$newtime>=tsL & tdf$formantVow=="f1.i", "formantValue"]))
      xs_u = c(xs_u, mean(tdf[tdf$newtime<=tsU & tdf$newtime>=tsL & tdf$formantVow=="f2.u", "formantValue"]))
      ys_u = c(ys_u, mean(tdf[tdf$newtime<=tsU & tdf$newtime>=tsL & tdf$formantVow=="f1.u", "formantValue"]))
   }
   res[[i]] = list(xs_a = xs_a, ys_a = ys_a, xs_i = xs_i, ys_i = ys_i, xs_u = xs_u, ys_u = ys_u)
  }

  par(mfrow=c(1,3))
  for (j in 1:3){
    plot(c(1:10), c(1:10), pch=19, col="white", xlim=xrange, ylim=yrange, xlab="F2 (Hz)", ylab="F1 (Hz)", xaxt="n", yaxt="n")
    axis(side=1, at=seq(xrange[1], xrange[2], by=200), label=seq(-1*xrange[1], -1*xrange[2], by=-200))
    axis(side=2, at=seq(yrange[1], yrange[2], by=100), label=seq(-1*yrange[1], -1*yrange[2], by=-100))

    for (i in 1:4){
      xs = c(res[[i]]$xs_a[j], res[[i]]$xs_i[j], res[[i]]$xs_u[j], res[[i]]$xs_a[j])
      ys = c(res[[i]]$ys_a[j], res[[i]]$ys_i[j], res[[i]]$ys_u[j], res[[i]]$ys_a[j])
      lines(-xs, -ys, col=i, xlim=xrange, ylim=yrange, lwd=2)
    }
    legend("bottomleft", devices, lwd=2, col=1:4, bty="n")
  }

}

plot_2D_formants_all <- function(dat, devices = c("H6", "AVR", "Zoom-default", "Zoom-raw"),
                                 xrange = c(-2600, -1200),
                                 yrange = c(-900,-300)){

  dat$device = relevel(as.factor(dat$device), "H6")
#  datcv$deviceOrd = as.ordered(datcv$device)
  vs = split(dat, dat$device)
  res = list()
  for (i in 1:length(vs)){
    tdf = vs[[i]]
    xs_a = vector()
    ys_a = vector()
    xs_i = vector()
    ys_i = vector()
    xs_u = vector()
    ys_u = vector()

    xs_a = c(xs_a, mean(tdf[tdf$formantVow=="f2.a", "formantValue"]))
    ys_a = c(ys_a, mean(tdf[tdf$formantVow=="f1.a", "formantValue"]))
    xs_i = c(xs_i, mean(tdf[tdf$formantVow=="f2.i", "formantValue"]))
    ys_i = c(ys_i, mean(tdf[tdf$formantVow=="f1.i", "formantValue"]))
    xs_u = c(xs_u, mean(tdf[tdf$formantVow=="f2.u", "formantValue"]))
    ys_u = c(ys_u, mean(tdf[tdf$formantVow=="f1.u", "formantValue"]))
   res[[i]] = list(xs_a = xs_a, ys_a = ys_a, xs_i = xs_i, ys_i = ys_i, xs_u = xs_u, ys_u = ys_u)
  }

  plot(c(1:10), c(1:10), pch=19, col="white", xlim=xrange, ylim=yrange, xlab="F2 (Hz)", ylab="F1 (Hz)", xaxt="n", yaxt="n")
  axis(side=1, at=seq(xrange[1], xrange[2], by=200), label=seq(-1*xrange[1], -1*xrange[2], by=-200))
  axis(side=2, at=seq(yrange[1], yrange[2], by=100), label=seq(-1*yrange[1], -1*yrange[2], by=-100))

  for (i in 1:4){
    xs = c(res[[i]]$xs_a, res[[i]]$xs_i, res[[i]]$xs_u, res[[i]]$xs_a)
    ys = c(res[[i]]$ys_a, res[[i]]$ys_i, res[[i]]$ys_u, res[[i]]$ys_a)
    lines(-xs, -ys, col=i, xlim=xrange, ylim=yrange, lwd=2)
  }
  legend("bottomleft", devices, lwd=2, col=1:4, bty="n")

}
